<?php
/*
 * Copyright (c) 2025 AltumCode (https://altumcode.com/)
 *
 * This software is licensed exclusively by AltumCode and is sold only via https://altumcode.com/.
 * Unauthorized distribution, modification, or use of this software without a valid license is not permitted and may be subject to applicable legal actions.
 *
 * 🌍 View all other existing AltumCode projects via https://altumcode.com/
 * 📧 Get in touch for support or general queries via https://altumcode.com/contact
 * 📤 Download the latest version via https://altumcode.com/downloads
 *
 * 🐦 X/Twitter: https://x.com/AltumCode
 * 📘 Facebook: https://facebook.com/altumcode
 * 📸 Instagram: https://instagram.com/altumcode
 */

defined('ALTUMCODE') || die();

return [
    'email' => [
        'format' => 'mailto:%s',
        'input_group' => null,
        'max_length' => 320,
        'icon' => 'fas fa-envelope'
    ],
    'tel'=> [
        'format' => 'tel: %s',
        'input_group' => null,
        'max_length' => 32,
        'icon' => 'fas fa-phone-square-alt'
    ],
    'telegram'=> [
        'format' => 'https://t.me/%s',
        'input_group' => true,
        'max_length' => 128,
        'icon' => 'fab fa-telegram'
    ],
    'whatsapp'=> [
        'format' => 'https://wa.me/%s',
        'input_group' => null,
        'max_length' => 32,
        'icon' => 'fab fa-whatsapp'
    ],
    'whatsapp_channel'=> [
        'format' => 'https://www.whatsapp.com/channel/%s',
        'input_group' => null,
        'max_length' => 64,
        'icon' => 'fab fa-whatsapp'
    ],
    'facebook'=> [
        'format' => 'https://facebook.com/%s',
        'input_group' => true,
        'max_length' => 128,
        'icon' => 'fab fa-facebook'
    ],
    'facebook-messenger'=> [
        'format' => 'https://m.me/%s',
        'input_group' => true,
        'max_length' => 128,
        'icon' => 'fab fa-facebook-messenger'
    ],
    'instagram'=> [
        'format' => 'https://instagram.com/%s',
        'input_group' => true,
        'max_length' => 128,
        'icon' => 'fab fa-instagram'
    ],
    'twitter'=> [
        'format' => 'https://x.com/%s',
        'input_group' => true,
        'max_length' => 128,
        'icon' => 'fab fa-twitter'
    ],
    'tiktok'=> [
        'format' => 'https://tiktok.com/@%s',
        'input_group' => true,
        'max_length' => 128,
        'icon' => 'fab fa-tiktok'
    ],
    'youtube'=> [
        'format' => 'https://youtube.com/%s',
        'input_group' => true,
        'max_length' => 128,
        'icon' => 'fab fa-youtube'
    ],
    'soundcloud'=> [
        'format' => 'https://soundcloud.com/%s',
        'input_group' => true,
        'max_length' => 128,
        'icon' => 'fab fa-soundcloud'
    ],
    'linkedin'=> [
        'format' => 'https://linkedin.com/%s',
        'input_group' => true,
        'max_length' => 128,
        'icon' => 'fab fa-linkedin'
    ],
    'spotify' => [
        'format' => 'https://open.spotify.com/artist/%s',
        'input_group' => true,
        'max_length' => 128,
        'icon' => 'fab fa-spotify'
    ],
    'pinterest' => [
        'format' => 'https://pinterest.com/%s',
        'input_group' => true,
        'max_length' => 128,
        'icon' => 'fab fa-pinterest'
    ],
    'snapchat' => [
        'format' => 'https://snapchat.com/add/%s',
        'input_group' => true,
        'max_length' => 128,
        'icon' => 'fab fa-snapchat'
    ],
    'twitch' => [
        'format' => 'https://twitch.tv/%s',
        'input_group' => true,
        'max_length' => 128,
        'icon' => 'fab fa-twitch'
    ],
    'discord' => [
        'format' => 'https://discord.gg/%s',
        'input_group' => true,
        'max_length' => 128,
        'icon' => 'fab fa-discord'
    ],
    'address' => [
        'format' => 'https://maps.google.com/maps?q=%s',
        'input_group' => false,
        'max_length' => 256,
        'icon' => 'fas fa-map-marker-alt'
    ],
    'threads' => [
        'format' => 'https://threads.net/@%s',
        'input_group' => true,
        'max_length' => 64,
        'icon' => 'fab fa-threads',
    ],
    'reddit' => [
        'format' => 'https://reddit.com/%s',
        'input_group' => true,
        'max_length' => 64,
        'icon' => 'fab fa-reddit',
    ],
    'rumble' => [
        'format' => 'https://rumble.com/%s',
        'input_group' => true,
        'max_length' => 128,
        'icon' => 'fas fa-play-circle',
    ],
    'vk'=> [
        'format' => 'https://vk.me/%s',
        'input_group' => true,
        'max_length' => 128,
        'icon' => 'fab fa-vk'
    ],
    'signal'=> [
        'format' => 'https://signal.me/%s',
        'input_group' => true,
        'max_length' => 256,
        'icon' => 'fa fa-comment'
    ],
    'skype'=> [
        'format' => 'https://join.skype.com/invite/%s',
        'input_group' => true,
        'max_length' => 256,
        'icon' => 'fab fa-skype'
    ],
];
