# [YooKassa API SDK](../home.md)

# Interface: PayerBankDetailsInterface
### Namespace: [\YooKassa\Model\PaymentMethod\B2b\Sberbank](../namespaces/yookassa-model-paymentmethod-b2b-sberbank.md)
---
**Summary:**

Interface PayerBankDetailsInterface

---
### Constants
* No constants found

---
### Methods
| Visibility | Name | Flag | Summary |
| ----------:| ---- | ---- | ------- |
| public | [getAccount()](../classes/YooKassa-Model-PaymentMethod-B2b-Sberbank-PayerBankDetailsInterface.md#method_getAccount) |  | Возвращает номер счета организации |
| public | [getAddress()](../classes/YooKassa-Model-PaymentMethod-B2b-Sberbank-PayerBankDetailsInterface.md#method_getAddress) |  | Возвращает адрес организации |
| public | [getBankBik()](../classes/YooKassa-Model-PaymentMethod-B2b-Sberbank-PayerBankDetailsInterface.md#method_getBankBik) |  | Возвращает БИК банка организации |
| public | [getBankBranch()](../classes/YooKassa-Model-PaymentMethod-B2b-Sberbank-PayerBankDetailsInterface.md#method_getBankBranch) |  | Возвращает отделение банка организации |
| public | [getBankName()](../classes/YooKassa-Model-PaymentMethod-B2b-Sberbank-PayerBankDetailsInterface.md#method_getBankName) |  | Возвращает наименование банка организации |
| public | [getFullName()](../classes/YooKassa-Model-PaymentMethod-B2b-Sberbank-PayerBankDetailsInterface.md#method_getFullName) |  | Возвращает полное наименование организации |
| public | [getInn()](../classes/YooKassa-Model-PaymentMethod-B2b-Sberbank-PayerBankDetailsInterface.md#method_getInn) |  | Возвращает ИНН организации |
| public | [getKpp()](../classes/YooKassa-Model-PaymentMethod-B2b-Sberbank-PayerBankDetailsInterface.md#method_getKpp) |  | Возвращает КПП организации |
| public | [getShortName()](../classes/YooKassa-Model-PaymentMethod-B2b-Sberbank-PayerBankDetailsInterface.md#method_getShortName) |  | Возвращает сокращенное наименование организации |

---
### Details
* File: [lib/Model/PaymentMethod/B2b/Sberbank/PayerBankDetailsInterface.php](../../lib/Model/PaymentMethod/B2b/Sberbank/PayerBankDetailsInterface.php)
* Package: \YooKassa

---
### Tags
| Tag | Version | Description |
| --- | ------- | ----------- |
| property-read |  | Полное наименование организации |
| property-read |  | Сокращенное наименование организации |
| property-read |  | Адрес организации |
| property-read |  | ИНН организации |
| property-read |  | КПП организации |
| property-read |  | Наименование банка организации |
| property-read |  | Отделение банка организации |
| property-read |  | БИК банка организации |
| property-read |  | Номер счета организации |

---
## Methods
<a name="method_getFullName" class="anchor"></a>
#### public getFullName() : string

```php
public getFullName() : string
```

**Summary**

Возвращает полное наименование организации

**Details:**
* Inherited From: [\YooKassa\Model\PaymentMethod\B2b\Sberbank\PayerBankDetailsInterface](../classes/YooKassa-Model-PaymentMethod-B2b-Sberbank-PayerBankDetailsInterface.md)

**Returns:** string - Полное наименование организации


<a name="method_getShortName" class="anchor"></a>
#### public getShortName() : string

```php
public getShortName() : string
```

**Summary**

Возвращает сокращенное наименование организации

**Details:**
* Inherited From: [\YooKassa\Model\PaymentMethod\B2b\Sberbank\PayerBankDetailsInterface](../classes/YooKassa-Model-PaymentMethod-B2b-Sberbank-PayerBankDetailsInterface.md)

**Returns:** string - Сокращенное наименование организации


<a name="method_getAddress" class="anchor"></a>
#### public getAddress() : string

```php
public getAddress() : string
```

**Summary**

Возвращает адрес организации

**Details:**
* Inherited From: [\YooKassa\Model\PaymentMethod\B2b\Sberbank\PayerBankDetailsInterface](../classes/YooKassa-Model-PaymentMethod-B2b-Sberbank-PayerBankDetailsInterface.md)

**Returns:** string - Адрес организации


<a name="method_getInn" class="anchor"></a>
#### public getInn() : string

```php
public getInn() : string
```

**Summary**

Возвращает ИНН организации

**Details:**
* Inherited From: [\YooKassa\Model\PaymentMethod\B2b\Sberbank\PayerBankDetailsInterface](../classes/YooKassa-Model-PaymentMethod-B2b-Sberbank-PayerBankDetailsInterface.md)

**Returns:** string - ИНН организации


<a name="method_getKpp" class="anchor"></a>
#### public getKpp() : string

```php
public getKpp() : string
```

**Summary**

Возвращает КПП организации

**Details:**
* Inherited From: [\YooKassa\Model\PaymentMethod\B2b\Sberbank\PayerBankDetailsInterface](../classes/YooKassa-Model-PaymentMethod-B2b-Sberbank-PayerBankDetailsInterface.md)

**Returns:** string - КПП организации


<a name="method_getBankName" class="anchor"></a>
#### public getBankName() : string

```php
public getBankName() : string
```

**Summary**

Возвращает наименование банка организации

**Details:**
* Inherited From: [\YooKassa\Model\PaymentMethod\B2b\Sberbank\PayerBankDetailsInterface](../classes/YooKassa-Model-PaymentMethod-B2b-Sberbank-PayerBankDetailsInterface.md)

**Returns:** string - Наименование банка организации


<a name="method_getBankBranch" class="anchor"></a>
#### public getBankBranch() : string

```php
public getBankBranch() : string
```

**Summary**

Возвращает отделение банка организации

**Details:**
* Inherited From: [\YooKassa\Model\PaymentMethod\B2b\Sberbank\PayerBankDetailsInterface](../classes/YooKassa-Model-PaymentMethod-B2b-Sberbank-PayerBankDetailsInterface.md)

**Returns:** string - Отделение банка организации


<a name="method_getBankBik" class="anchor"></a>
#### public getBankBik() : string

```php
public getBankBik() : string
```

**Summary**

Возвращает БИК банка организации

**Details:**
* Inherited From: [\YooKassa\Model\PaymentMethod\B2b\Sberbank\PayerBankDetailsInterface](../classes/YooKassa-Model-PaymentMethod-B2b-Sberbank-PayerBankDetailsInterface.md)

**Returns:** string - БИК банка организации


<a name="method_getAccount" class="anchor"></a>
#### public getAccount() : string

```php
public getAccount() : string
```

**Summary**

Возвращает номер счета организации

**Details:**
* Inherited From: [\YooKassa\Model\PaymentMethod\B2b\Sberbank\PayerBankDetailsInterface](../classes/YooKassa-Model-PaymentMethod-B2b-Sberbank-PayerBankDetailsInterface.md)

**Returns:** string - Номер счета организации




---

### Top Namespaces

* [\YooKassa](../namespaces/yookassa.md)

---

### Reports
* [Errors - 0](../reports/errors.md)
* [Markers - 1](../reports/markers.md)
* [Deprecated - 43](../reports/deprecated.md)

---

This document was automatically generated from source code comments on 2024-09-18 using [phpDocumentor](http://www.phpdoc.org/)

&copy; 2024 YooMoney